﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.POSRetail.Controls.Loading;
using AZVIC.Ei8htPOS.POSRetail.Helpers;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace AZVIC.Ei8htPOS.POSRetail.Pages
{
    /// <summary>
    /// Interaction logic for MasterSalesReport.xaml
    /// </summary>
    public partial class MasterSalesReport : Page
    {
        public MasterSalesReport()
        {
            InitializeComponent();
        }

        private void BindReport(DateTime StartDate, DateTime EndTime)
        {
            ProgressDialogResult result = ProgressDialog.Execute(Application.Current.MainWindow, string.Empty, (bw, we) =>
            {
                DataTable dt = ReportsBL.GetMasterSalesReport(StartDate, EndTime);
                gvMasterSales.Dispatcher.BeginInvoke(new Action(() => gvMasterSales.ItemsSource = dt.DefaultView));
            });
        }

        private void btnSearch_Click_1(object sender, RoutedEventArgs e)
        {
            DateTime StartTime = dtStartDate.SelectedDate!=null?dtStartDate.SelectedDate.Value:DateTime.MinValue;
            DateTime EndTime = dtEndDate.SelectedDate!=null?dtEndDate.SelectedDate.Value:DateTime.MinValue;
            BindReport(StartTime, EndTime);
        }

        private void btnGenerate_Click_1(object sender, RoutedEventArgs e)
        {
            ExcelExportHelper.Export(gvMasterSales, "MasterSalesReport");
        }
    }
}
